/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpEngine.DpInterface;
import ibm.nways.analysis.dpManager.DpeRequestWorker;
import ibm.nways.analysis.dpManager.Work;
import ibm.nways.analysis.dpManager.dpServerImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DpeWorkerManager {
    private int amountOfWork;
    private boolean finalResult = true;
    private Hashtable workers = new Hashtable();

    public void addWork(DpInterface dpInterface, Vector vector, int n) {
        if (vector != null && vector.size() > 0) {
            Work work = new Work(this, dpInterface, vector, n);
            try {
                ++this.amountOfWork;
                DpeRequestWorker dpeRequestWorker = (DpeRequestWorker)this.workers.get(dpInterface.getHostname().getHostAddress());
                if (dpeRequestWorker == null) {
                    dpeRequestWorker = new DpeRequestWorker(work);
                    this.workers.put(dpInterface.getHostname().getHostAddress(), dpeRequestWorker);
                    return;
                }
                dpeRequestWorker.addWork(work);
                return;
            }
            catch (Exception exception) {
                dpServerImpl.DM("DpeWorkerManager:exception occurred:", exception);
                return;
            }
        }
        dpServerImpl.DM("POI null or size is 0");
    }

    public synchronized void startAndWait() {
        if (this.amountOfWork > 0) {
            Enumeration enumeration = this.workers.elements();
            while (enumeration.hasMoreElements()) {
                DpeRequestWorker dpeRequestWorker = (DpeRequestWorker)enumeration.nextElement();
                dpeRequestWorker.start();
            }
            try {
                this.wait();
                return;
            }
            catch (Exception exception) {
                dpServerImpl.DM("DpeWorkerManager:exception occurred:", exception);
                return;
            }
        }
        dpServerImpl.DM("Error: Server did failed to give work to do, so DPE worker is going back to sleep!");
    }

    public synchronized void startAndReturn() {
        if (this.amountOfWork > 0) {
            Enumeration enumeration = this.workers.elements();
            while (enumeration.hasMoreElements()) {
                DpeRequestWorker dpeRequestWorker = (DpeRequestWorker)enumeration.nextElement();
                dpeRequestWorker.start();
            }
            return;
        }
        dpServerImpl.DM("Error: Server did failed to give work to do, so DPE worker is going back to sleep!");
    }

    public boolean getResult() {
        return this.finalResult;
    }

    public synchronized void reportDone(DpInterface dpInterface, boolean bl) {
        this.finalResult = this.finalResult && bl;
        --this.amountOfWork;
        if (this.amountOfWork == 0) {
            this.notify();
        }
    }
}

